export const UNITS = (() => {
    const screenGap = 16;
    const triggerSize = 60;
    const reverseMultiplier = -1;
    const triggerGap = triggerSize + 12;

    return {
        screenGap,
        triggerSize,
        triggerGap,
        reverseMultiplier,
    };
})();

export const SIZES = [
    // 'sm',
    'md',
    'lg',
    'xl',
    'full',
];

export const SIZE_WIDTH = {
    'sm': 380,
    'md': 380,
    'lg': 380,
    'xl': 600,
}

export const PARAMETERS = {
    position: {
        right: {
            top: null,
            right: UNITS.screenGap,
            bottom: UNITS.screenGap,
            left: null,
        },
        left: {
            top: null,
            right: null,
            bottom: UNITS.screenGap,
            left: UNITS.screenGap,
        }
    },
    trigger: {
        size: UNITS.triggerSize,
        gap: UNITS.triggerGap,
        color: '#458CF6',
        colorRGB: '#69, 140, 246'
    },
}
