import {useContext} from "@wordpress/element";
import {ChatBotsContext} from "../../../contexts/chatbots";
import Single from '../../components/trigger/single';
import Multi from '../../components/trigger/multi';

export default function Trigger({toggleChatbots, leadCaptureBlocking}) {
    const chatbotsContext = useContext(ChatBotsContext);

    if (chatbotsContext.chatbots?.length) {
        if (chatbotsContext.chatbots?.length === 1) {
            return <Single toggleChatbots={toggleChatbots} leadCaptureBlocking={leadCaptureBlocking}/>;
        } else {
            return <Multi toggleChatbots={toggleChatbots} leadCaptureBlocking={leadCaptureBlocking}/>;
        }
    } else {
        return false;
    }
}