import {createPortal} from '@wordpress/element';

export default function PopupContainer({title, description, close, showLoadingContainer, style, bodyClassName, children, footer, rootRef}) {
    return createPortal(<div className="lbaic-popup-layout">
        <div className='lbaic-popup-overlay' onClick={close}/>
        <div className='lbaic-popup' style={style}>
            <div className='lbaic-popup-in'>
                <div className='lbaic-popup-header'>
                    <div className='lbaic-popup-header-in'>
                        <h6 className='lbaic-popup-header-label'>{title}</h6>
                        {description?.length > 0 && <p className='lbaic-popup-header-desc'>{description}</p>}
                    </div>
                </div>
                {children &&
                    <>
                        <div className='lbaic-divider lbaic-divider-popup'/>
                        <div className={`lbaic-popup-body${bodyClassName ? ' ' + bodyClassName : ''}`}>
                            {showLoadingContainer && <div className="lbaic-popup-loading"/>}
                            <div className='lbaic-popup-body-in lbaic-scroll-color'>
                                {children}
                            </div>
                        </div>
                    </>}
                {footer &&
                    <div className='lbaic-popup-footer'>
                        {footer}
                    </div>}
            </div>
        </div>
    </div>, rootRef.current);
}