import {prepareUserMessage} from "../../../../../../../helpers";

export default function WidgetRow({widgetRow, sendMessage}) {
    if (widgetRow.type === 'link') {
        const rel = widgetRow.data.target === '_blank' ? 'noopener' : false;

        return <div className="lbaic-intro-item">
            <a className='lbaic-intro-row' href={widgetRow.data.url}
               target={widgetRow.data.target || false} rel={rel}>
                <div className='lbaic-intro-row-in'>
                    <span className='lbaic-intro-row-label' dangerouslySetInnerHTML={{__html: widgetRow.data.text}}/>
                    <svg className='lbaic-intro-row-icon' xmlns='http://www.w3.org/2000/svg' fill='none'
                         viewBox='0 0 24 24'>
                        <use href='#lbaic-arrow' className="lbaic-arrow"/>
                        <use href='#lbaic-external-box'/>
                    </svg>
                </div>
            </a>
        </div>
    } else if (widgetRow.type === 'prompt') {
        return widgetRow.data.content?.map((contentItem, index) => {
            // Use Message field if available, otherwise fallback to Content for backward compatibility
            const messageToSend = widgetRow.data?.message || contentItem[contentItem.type]?.value || '';
            // Use Content as label
            const labelText = contentItem[contentItem.type]?.value || '';

            return <div key={widgetRow.id + index} className="lbaic-intro-item">
                <div className='lbaic-intro-row'
                     onClick={() => sendMessage(
                         prepareUserMessage({
                             [contentItem.type]: messageToSend,
                         }),
                         false,
                         {
                             cancelCurrentAction: true
                         }
                     )}>
                    <div className='lbaic-intro-row-in'>
                        {contentItem.type === 'text' &&
                            <span
                                className='lbaic-intro-row-label'
                                dangerouslySetInnerHTML={{__html: labelText}}/>}
                        <svg className='lbaic-intro-row-icon lbaic-intro-row-icon-nc '
                             xmlns='http://www.w3.org/2000/svg'
                             fill='none' viewBox='0 0 24 24'>
                            <use href='#lbaic-cloud'/>
                            <use href='#lbaic-plus-horizontal' className="lbaic-plus"/>
                            <use href='#lbaic-plus-vertical' className="lbaic-plus"/>
                        </svg>
                    </div>
                </div>
            </div>
        });
    } else if (widgetRow.type === 'text') {
        return (
            <div className="lbaic-intro-item">
                <div className='lbaic-intro-text' dangerouslySetInnerHTML={{__html: widgetRow.data?.content || ''}}/>
            </div>
        );
    } else if (widgetRow.type === 'search') {
        return <div className='lbaic-intro-search'>
            <div className='lbaic-intro-search-input'>
                <svg className='lbaic-intro-search-input-icon' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-search'/>
                </svg>
                <input
                    type='search'
                    className='lbaic-intro-search-input-in'
                    placeholder='Search'
                    autoComplete="off"
                />
            </div>
            <div className='lbaic-intro-search-body'>
                <div className='lbaic-intro-search-row'>
                    <span className='lbaic-intro-search-row-label'>How do i take my website live?</span>
                    <svg className='lbaic-intro-search-row-icon' xmlns='http://www.w3.org/2000/svg' fill='none'
                         viewBox='0 0 24 24'>
                        <use href='#lbaic-chevron-right'/>
                    </svg>
                </div>
                <div className='lbaic-intro-search-row'>
                    <span className='lbaic-intro-search-row-label'>How to download the backups of your application</span>
                    <svg className='lbaic-intro-search-row-icon' xmlns='http://www.w3.org/2000/svg' fill='none'
                         viewBox='0 0 24 24'>
                        <use href='#lbaic-chevron-right'/>
                    </svg>
                </div>
            </div>
        </div>
    }
}