import {useEffect, useState} from "@wordpress/element";

export default function HomeSection({title, action, bodyClassName, children}) {
    const [className, setClassName] = useState('');

    useEffect(() => {
        const timer = setTimeout(() => setClassName('show-widgets'), 100);

        return () => clearTimeout(timer);
    }, []);

    return <div className='lbaic-intro-section'>
        <div className={`lbaic-intro-section-in${className ? ' ' + className : ''}`}>
            {title?.length > 0 &&
                <div className='lbaic-intro-section-header'>
                    <span className='lbaic-intro-section-header-in' dangerouslySetInnerHTML={{__html: title}}/>
                    {typeof action?.callback === 'function' &&
                        <button className='lbaic-intro-section-header-action'
                                onClick={action.callback}>
                            <svg className='lbaic-intro-section-header-action-i'
                                 xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                                <use href={`#lbaic-${action.icon}`}/>
                            </svg>
                        </button>}
                </div>}
            <div className={`lbaic-intro-section-body${bodyClassName ? ' ' + bodyClassName : ''}`}>{children}</div>
        </div>
    </div>
}