import {useEffect, useRef, useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";

export default function ChatsHistory({title, getChats, chatSelected, setChatScreen}) {
    // States
    const [loading, setLoading] = useState(0);
    // Chats
    const [chats, setChats] = useState([]);
    const pagination = useRef({
        page: 0,
        perPage: 5,
        total: 0
    });

    useEffect(() => {
        loadChatsHistory();
    }, []);

    /**
     * Get chats
     */
    const loadChatsHistory = async () => {
        setLoading(prev => prev + 1);
        const res = await getChats({
            page: pagination.current.page + 1,
            per_page: pagination.current.perPage,
            orderby: 'id',
            order: 'desc',
        });
        if (res?.items?.length) {
            pagination.current.page++;
            pagination.current.total = +res.total;
            setChats(prevState => [...prevState, ...res.items]);
        }
        setLoading(prev => prev - 1);
    }

    return <div className="lbaic-intro-item">
        <div className="lbaic-intro-label">
            <div className='lbaic-intro-label-in'>
                {title?.length > 0 &&
                    <button className='lbaic-intro-label-header lbaic-intro-label-header-nested'
                            onClick={() => setChatScreen('chat-history')}>
                        <span className='lbaic-intro-label-header-in' dangerouslySetInnerHTML={{__html: title}}/>
                        <div className='lbaic-intro-label-desc'>
                            <svg className='lbaic-intro-label-desc-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                                 viewBox='0 0 24 24'>
                                <use href='#lbaic-arrow-right'/>
                            </svg>
                        </div>
                    </button>}
                <div className='lbaic-intro-label-body lbaic-intro-label-body-scroll'>
                    {chats.map(chat =>
                        <button key={chat.uuid} className='lbaic-intro-scroll-row'
                                onClick={() => chatSelected(chat.uuid)}>
                            <div className='lbaic-intro-scroll-row-in'>
                                <span className='lbaic-intro-row-label'
                                      dangerouslySetInnerHTML={{__html: chat.name || __("N/A", 'limb-chatbot')}}/>
                                <div className='lbaic-intro-label-desc'>
                                    <svg className='lbaic-intro-label-desc-i' xmlns='http://www.w3.org/2000/svg'
                                         fill='none'
                                         viewBox='0 0 24 24'>
                                        <use href='#lbaic-arrow-right'/>
                                    </svg>
                                </div>
                            </div>
                        </button>)}
                </div>
            </div>
        </div>
    </div>
}