import {useRef, useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import ButtonMinimal from "../../button/minimal";
import ToggleButton from "../../toggle-button";
import useClickOutside from "../../../../hooks/use-click-outside";

export default function KebabMenu({chatbot, clearChat, hasMessages, chatScreen, setChatScreen, sound}) {
    const [opened, setOpened] = useState(false);
    const menuRef = useRef(null);

    useClickOutside([menuRef], () => setOpened(false));

    const toggleMenu = (e) => {
        e.stopPropagation();
        setOpened(!opened);
    }

    const handleActionClick = (callback) => {
        callback();
        setOpened(false);
    }

    return <>
        {chatScreen !== 'chat-history' &&
            <ButtonMinimal classes='lbaic-button-minimal-28' icon='kebab' onClick={toggleMenu}/>}
        {opened &&
            <div className='lbaic-header-actions-menu' ref={menuRef}>
                {chatScreen !== 'chat-history' &&
                    <div className='lbaic-header-actions-menu-item'>
                        <button
                            type="button"
                            className='lbaic-header-actions-menu-item-in'
                            onClick={() => handleActionClick(() => setChatScreen('chat-history'))}
                        >
                            <svg className='lbaic-header-actions-menu-item-i' xmlns='http://www.w3.org/2000/svg'
                                 viewBox='0 0 24 24'>
                                <use href='#lbaic-history'/>
                            </svg>
                            <span
                                className='lbaic-header-actions-menu-item-label'>{__("History", 'limb-chatbot')}</span>
                        </button>
                    </div>}
                {chatbot.utility.clean && chatScreen !== 'chat-history' &&
                    <div className='lbaic-header-actions-menu-item'>
                        <button
                            type="button"
                            className={`lbaic-header-actions-menu-item-in${!hasMessages ? ' lbaic-button-disabled' : ''}`}
                            onClick={() => handleActionClick(clearChat)}
                        >
                            <svg className='lbaic-header-actions-menu-item-i' xmlns='http://www.w3.org/2000/svg'
                                 viewBox='0 0 24 24'>
                                <use href='#lbaic-clean'/>
                            </svg>
                            <span className='lbaic-header-actions-menu-item-label'>{__("Clear", 'limb-chatbot')}</span>
                        </button>
                    </div>}
                {Boolean(chatbot.utility.sound) && (
                    <div className='lbaic-header-actions-menu-item'>
                        <div className='lbaic-header-actions-menu-item-in'>
                            <svg className='lbaic-header-actions-menu-item-i' xmlns='http://www.w3.org/2000/svg'
                                 viewBox='0 0 24 24'>
                                <use href='#lbaic-sound'/>
                            </svg>
                            <span className='lbaic-header-actions-menu-item-label'>{__("Sound", 'limb-chatbot')}</span>
                            <ToggleButton onClick={() => sound.set(!sound.get)} isActive={sound.get}/>
                        </div>
                    </div>
                )}
            </div>}
    </>
}