import {__} from '@wordpress/i18n';
import ButtonMinimal from '../button/minimal';
import KebabMenu from "./kebab-menu";
import Tooltip from "../tooltip";
import {IS_MOBILE_DEVICE} from "../../containers/single";

export default function Header({chatbot, close, clearChat, hasMessages, size, chatScreen, setChatScreen, sound, viewMode}) {
    const showCloseButton = chatbot.utility.close_button && viewMode !== 'wp-block';

    return (
        <div className='lbaic-header'>
            <div className='lbaic-header-in'>
                {chatScreen === 'chat-history' ?
                    <>
                        <Tooltip title={__("Messages", 'limb-chatbot')}
                                 tooltipPosition='bottom' arrowPosition='left'>
                            <ButtonMinimal classes='lbaic-button-minimal-28'
                                           onClick={() => setChatScreen('chat')} icon='chevron-left'/>
                        </Tooltip>
                        <span className='lbaic-header-label'>{__("History", 'limb-chatbot')}</span>
                    </>
                    :
                    <Tooltip title={__("Home", 'limb-chatbot')} tooltipPosition='bottom' arrowPosition='left'>
                        <ButtonMinimal classes='lbaic-button-minimal-28'
                                       onClick={() => setChatScreen('home')} icon='chevron-left'/>
                    </Tooltip>}
            </div>
            <div className='lbaic-header-actions'>
                <div className='lbaic-header-actions-in'>
                    <KebabMenu chatbot={chatbot} clearChat={clearChat}
                               hasMessages={hasMessages} chatScreen={chatScreen} setChatScreen={setChatScreen} sound={sound}/>
                </div>
                {!IS_MOBILE_DEVICE && (
                    <div className='lbaic-header-actions-in lbaic-header-actions-size'>
                        <Tooltip title={__("Change size", 'limb-chatbot')} tooltipPosition='bottom'
                                 arrowPosition={showCloseButton ? 'center' : 'right'}>
                            <ButtonMinimal classes='lbaic-button-minimal-28' onClick={size.set} icon={`size-${size.get}`}/>
                        </Tooltip>
                    </div>
                )}
                {showCloseButton &&
                    <div className='lbaic-header-actions-in'>
                        <Tooltip title={__("Close", 'limb-chatbot')} tooltipPosition='bottom' arrowPosition='right'>
                            <ButtonMinimal classes='lbaic-button-minimal-28' onClick={() => close(chatbot.uuid)}
                                           icon='close'/>
                        </Tooltip>
                    </div>}
            </div>
        </div>
    )
}