import {getInputComponent, validateInput as validateInputValue} from '../inputs';

/**
 * Validate input value based on input type
 * Re-export for backward compatibility
 *
 * @param {string} value Input value
 * @param {string} inputType Input type
 * @returns {boolean} Is valid
 */
export const validateInput = validateInputValue;

/**
 * MessageInput Component
 * Renders the appropriate input component based on inputType
 *
 * @param {Object} props Component props
 * @param {React.Ref} props.textareaRef Textarea ref
 * @param {string} props.text Current text value
 * @param {Function} props.onTextChange Text change handler
 * @param {Function} props.onKeyDown Key down handler
 * @param {string} props.inputType Input type (text, email, phone, url, buttons, textarea, recommendation)
 * @param {string} props.placeholder Custom placeholder from parameter data
 * @param {boolean} props.isValid Is input valid
 * @param {Object} props.config Configuration object for input type (e.g., options for buttons)
 * @param {Function} props.onButtonClick Button click handler for auto-submit
 * @param {Object} props.parameter Parameter object (for recommendation)
 * @param {Function} props.onCancelAction Cancel action handler
 * @param {Function} props.onSkipAction Skip action handler
 * @param {boolean} props.skipDisabled Is skip disabled
 * @param {string} props.skipLabel Skip button label
 * @param {Function} props.send Send message function
 * @param {Object} props.chatbotUtility Chatbot utility object
 * @param {boolean} props.isInProcess Is process running
 * @param {boolean} props.isSavingPreviewSettings Is saving preview settings
 * @param {boolean} props.sendDisabled Is send disabled
 * @param {string} props.sendLabel Send button label
 * @param {string} props.parameterLabel Parameter label
 */
export default function MessageInput({
                                          textareaRef,
                                          text,
                                          onTextChange,
                                          onKeyDown,
                                          inputType,
                                          placeholder,
                                          isValid,
                                          config,
                                          onButtonClick,
                                          parameter,
                                          onCancelAction,
                                          onSkipAction,
                                          skipDisabled,
                                          skipLabel,
                                          send,
                                          chatbotUtility,
                                          isInProcess,
                                          isSavingPreviewSettings,
                                          sendDisabled,
                                          sendLabel,
                                          parameterLabel
                                      }) {
    // Get the appropriate input component based on type
    const InputComponent = getInputComponent(inputType);

    // Pass all props including placeholder to all input types
    const inputProps = {
        textareaRef,
        text,
        onTextChange,
        onKeyDown,
        isValid,
        placeholder,
        config,
        onButtonClick,
        parameter,
        onCancelAction,
        onSkipAction,
        skipDisabled,
        skipLabel,
        send,
        chatbotUtility,
        isInProcess,
        isSavingPreviewSettings,
        sendLabel
    };

    return <InputComponent {...inputProps} />;
}