import {__} from "@wordpress/i18n";

/**
 * TextareaInput Component
 * Multi-line textarea input for longer messages
 *
 * @param {Object} props Component props
 * @param {React.Ref} props.textareaRef Textarea ref
 * @param {string} props.text Current text value
 * @param {Function} props.onTextChange Text change handler
 * @param {Function} props.onKeyDown Key down handler
 * @param {string} props.placeholder Custom placeholder
 */
export default function TextareaInput({
                                          textareaRef,
                                          text,
                                          onTextChange,
                                          onKeyDown,
                                          placeholder
                                      }) {
    const placeholderText = placeholder || __('Write a message...', 'limb-chatbot');

    return (
        <textarea
            ref={textareaRef}
            className='lbaic-textarea'
            placeholder={placeholderText}
            value={text}
            onChange={onTextChange}
            onKeyDown={onKeyDown}
        />
    );
}

/**
 * Validate textarea input (always valid)
 *
 * @param {string} value Input value
 * @returns {boolean} Always returns true
 */
export const validateTextareaInput = (value) => {
    return true;
};

