import {__} from "@wordpress/i18n";

/**
 * TextInput Component
 * No validation required for text input
 *
 * @param {Object} props Component props
 * @param {React.Ref} props.textareaRef Textarea ref
 * @param {string} props.text Current text value
 * @param {Function} props.onTextChange Text change handler
 * @param {Function} props.onKeyDown Key down handler
 * @param {string} props.placeholder Custom placeholder
 */
export default function TextInput({
                                      textareaRef,
                                      text,
                                      onTextChange,
                                      onKeyDown,
                                      placeholder
                                  }) {
    const placeholderText = placeholder || __('Write a message...', 'limb-chatbot');

    return (
        <input
            ref={textareaRef}
            type="text"
            className='lbaic-textarea'
            placeholder={placeholderText}
            value={text}
            onChange={onTextChange}
            onKeyDown={onKeyDown}
            autoComplete="off"
        />
    );
}

/**
 * DefaultTextarea Component
 * Default textarea shown when no specific input type is provided by AI
 *
 * @param {Object} props Component props
 * @param {React.Ref} props.textareaRef Textarea ref
 * @param {string} props.text Current text value
 * @param {Function} props.onTextChange Text change handler
 * @param {Function} props.onKeyDown Key down handler
 * @param {string} props.placeholder Custom placeholder
 */
export function DefaultTextarea({
                                    textareaRef,
                                    text,
                                    onTextChange,
                                    onKeyDown,
                                    placeholder
                                }) {
    const placeholderText = placeholder || __('Write a message...', 'limb-chatbot');

    return (
        <textarea
            ref={textareaRef}
            className='lbaic-textarea'
            placeholder={placeholderText}
            value={text}
            onChange={onTextChange}
            onKeyDown={onKeyDown}
        />
    );
}

/**
 * Validate text input (always valid)
 *
 * @param {string} value Input value
 * @returns {boolean} Always returns true
 */
export const validateTextInput = (value) => {
    return true;
};

