import PropTypes from 'prop-types';

const ButtonSkip = ({onClick, label, disabled}) => {
    return (
        <button
            className={`lbaic-button lbaic-button-center lbaic-button-skip lbaic-button-skip-with-${label ? 'label' : 'icon'}${disabled ? ' lbaic-button-disabled' : ''}`}
            onClick={() => !disabled && onClick()}
            disabled={disabled}>
            <span className='lbaic-button-skip-label'>{label}</span>
        </button>
    )
}

ButtonSkip.propTypes = {
    onClick: PropTypes.func.isRequired,
}

export default ButtonSkip;