import PropTypes from 'prop-types';

const ButtonSend = ({icon, onClick, label, loading, disabled}) => {
    return (
        <button
            type="button"
            className={`lbaic-button lbaic-button-center lbaic-button-send lbaic-button-send-with-${label ? 'label' : 'icon'}${loading ? ' lbaic-button-send-loading': ''}${disabled ? ' lbaic-button-disabled' : ''}`}
            onClick={() => !disabled && onClick()}
            disabled={disabled}
        >
            {
                label ? (
                    <span className='lbaic-button-send-label'>{label}</span>
                ) : (
                    <svg xmlns='http://www.w3.org/2000/svg'>
                        <use href={`#lbaic-${icon}`}/>
                    </svg>
                )
            }
        </button>
    )
}

ButtonSend.propTypes = {
    onClick: PropTypes.func.isRequired,
}

export default ButtonSend;