export default function ButtonRounded ({className, icon, onClick, onMouseEnter, onMouseLeave, disabled = false}) {
    return <button className={`lbaic-button lbaic-button-rounded${className ? ' ' + className : ''}`}
                   onClick={onClick}
                   onMouseEnter={onMouseEnter}
                   onMouseLeave={onMouseLeave}
                   disabled={disabled}>
        <svg xmlns='http://www.w3.org/2000/svg'>
            <use href={`#lbaic-${icon}`}/>
        </svg>
    </button>
}