export default function ButtonPrimary({label, icon, onClick, loading, disabled, labelProps, ...props}) {
    return (
        <button
            type="button"
            className={`lbaic-button lbaic-button-primary lbaic-button-center${loading ? ' lbaic-button-loading': ''}${disabled ? ' lbaic-button-disabled' : ''}`}
            onClick={() => !disabled && onClick()}
            disabled={disabled}
            {...props}
        >
            {icon && (
                <svg xmlns='http://www.w3.org/2000/svg'>
                    <use href={`#lbaic-${icon}`}/>
                </svg>
            )}
            {label && (
                <span className='lbaic-button-label' {...labelProps}>{label}</span>
            )}
        </button>
    )
}