export default function ButtonMinimal({classes, icon, onClick, onMouseEnter, onMouseLeave}) {
    return (
        <button
            type="button"
            className={`lbaic-button lbaic-button-minimal${classes ? ' ' + classes : ''}`}
            onClick={onClick}
            onMouseEnter={onMouseEnter}
            onMouseLeave={onMouseLeave}
        >
            <svg xmlns='http://www.w3.org/2000/svg'>
                <use href={`#lbaic-${icon}`}/>
            </svg>
        </button>
    );
}