import PropTypes from 'prop-types';

const ButtonFilled = ({classes, icon, onClick}) => {
    return (
        <button className={`lbaic-button lbaic-button-filled${classes ? ' ' + classes : ''}`} onClick={onClick}>
            <svg xmlns='http://www.w3.org/2000/svg'>
                <use href={`#lbaic-${icon}`}/>
            </svg>
        </button>
    )
}

ButtonFilled.propTypes = {
    icon: PropTypes.string.isRequired,
    onClick: PropTypes.func.isRequired
}

export default ButtonFilled;
