import {useEffect, useRef, useState, memo} from "@wordpress/element";
import Stream from "./stream";
import Simple from "./simple";

// Shared message content renderer
const MessageContent = memo(function MessageContent({
                                                        messageRef,
                                                        message,
                                                        stream,
                                                        setIsStreamTyping,
                                                        messageListRef,
                                                        children,
                                                        showCheckIcon
                                                    }) {
    const [show, setShow] = useState(false);

    useEffect(() => {
        let timeout;
        if (showCheckIcon) {
            timeout = setTimeout(() => {
                setShow(true);
            }, 500);
        }

        return () => {
            if (timeout) {
                clearTimeout(timeout);
            }
        }
    }, [showCheckIcon, message]);

    return (
        <div ref={messageRef} className={`lbaic-message-in${show ? ' lbaic-message-in-with-check' : ''}`}>
            <div className='lbaic-message-text-content'>
                {stream ?
                    <Stream message={message} setIsTyping={setIsStreamTyping} messageListRef={messageListRef}/>
                    :
                    <Simple message={message}/>}
                {children}
            </div>
            {show && (
                <div className='lbaic-message-check'>
                    <svg xmlns='http://www.w3.org/2000/svg' fill='none'>
                        <use href='#lbaic-check'/>
                    </svg>
                </div>
            )}
        </div>
    );
});

// Message wrapper without animation
const StaticMessage = memo(function StaticMessage({
                                                      message,
                                                      stream,
                                                      setIsStreamTyping,
                                                      messageListRef,
                                                      children,
                                                      showCheckIcon = false
                                                  }) {
    const messageRef = useRef(null);

    return <MessageContent
        messageRef={messageRef}
        message={message}
        stream={stream}
        setIsStreamTyping={setIsStreamTyping}
        messageListRef={messageListRef}
        showCheckIcon={showCheckIcon}
    >
        {children}
    </MessageContent>;
});

const MessageText = memo(function MessageText({
                                                  message,
                                                  stream,
                                                  setIsStreamTyping,
                                                  messageListRef,
                                                  children,
                                                  messageShowCheckIcon = false
                                              }) {
    if (!message?.length) {
        return null;
    }

    const messageProps = {
        message,
        stream,
        setIsStreamTyping,
        messageListRef,
        children,
        showCheckIcon: messageShowCheckIcon
    };

    return <StaticMessage {...messageProps} />;
});

export default MessageText;