const MessageLinkList = ({linkList}) => {
    return (
        <div className='lbaic-message-row'>
            <div className='lbaic-message-ll'>
                {
                    linkList.map((link, index) => {
                        return (
                            <div key={index} className='lbaic-message-ll-item'>
                                {
                                    link.imageUrl && (
                                        <div className='lbaic-message-ll-img'>
                                            <img className='lbaic-message-ll-img-in' src={link.imageUrl}
                                                 alt={link.description}/>
                                        </div>
                                    )
                                }
                                <div className='lbaic-message-ll-in'>
                                    <div className='lbaic-message-ll-desc'>
                                        <p className='lbaic-message-ll-desc-in'>
                                            {link.description}
                                        </p>
                                    </div>
                                    <div className='lbaic-message-ll-link'>
                                        <a href={link.url} className='lbaic-message-ll-link-in'
                                           target='_blank' rel="noopener">
                                            {link.url}
                                        </a>
                                    </div>
                                    <div className='lbaic-message-ll-date'>
                        <span className='lbaic-message-ll-date-in'>
                          {link.date}
                        </span>
                                    </div>
                                </div>
                            </div>
                        )
                    })
                }
            </div>
        </div>
    )
}

export default MessageLinkList;