import {memo} from "@wordpress/element";
import {prepareChatbotMessage} from "../../../../../../../../helpers";

const ActionSubmission = memo(function ActionSubmission({actionSubmission}) {
    const {message, data_fields, success} = actionSubmission;
    const isSuccess = success !== false; // Default to true if not explicitly false
    const iconName = isSuccess ? 'action-done' : 'information';

    return (
        <div className='lbaic-message-in lbaic-message-action-submission'>
            <div className={`lbaic-message-action-submission-status${isSuccess ? ' success' : ' error'}`}>
                <svg className='lbaic-message-action-submission-status-i' xmlns='http://www.w3.org/2000/svg'>
                    <use href={`#lbaic-${iconName}`}/>
                </svg>
            </div>
            <div className='lbaic-message-action-submission-content'>
                {message && (
                    <div className='lbaic-message-info' dangerouslySetInnerHTML={{__html: prepareChatbotMessage(message)}}></div>
                )}
                {data_fields && Object.keys(data_fields).length > 0 && (
                    <>
                        <div className='lbaic-message-data-divider'></div>
                        <div className='lbaic-message-data-fields'>
                            {Object.entries(data_fields).map(([key, value]) => (
                                <div key={key} className='lbaic-message-data-field-row'>
                                    <span className='lbaic-message-data-field-label'>
                                        {key.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())}:
                                    </span>
                                    <span className='lbaic-message-data-field-value'>
                                        {value || 'None'}
                                    </span>
                                </div>
                            ))}
                        </div>
                    </>
                )}
            </div>
        </div>
    );
});

export default ActionSubmission;