import {useContext, memo} from "@wordpress/element";
import Action from "../action";
import ButtonRounded from "../../../button/rounded";
import {MessagesContext} from "../_context/messages";
import RealTimeRelativeTime from "../real-time-relative-time";

const Message = memo(function Message({role, icon, title, time, actions, errors, children, agentName}) {
    const messagesContext = useContext(MessagesContext);

    /**
     * Error callback
     */
    const errorCallback = (...callbackArgs) => {
        if (role === 'user') {
            // Resend the user message
            if (typeof messagesContext.userErrorCallback === 'function') {
                messagesContext.userErrorCallback(...callbackArgs);
            }
        } else {
            // Run the chat
            if (typeof messagesContext.chatbotErrorCallback === 'function') {
                messagesContext.chatbotErrorCallback(...callbackArgs);
            }
        }
    }

    const hasContainer = children?.length ? Boolean(children[0]?.props?.message) : Boolean(children?.props?.message); // TODO check this condition
    const hasActions = actions?.length > 0 || time?.length > 0 || agentName;
    const showTitle = role === 'assistant' && Boolean(icon || title);

    return <div className={`lbaic-message-row lbaic-message-${role === 'user' ? 'user' : 'bot'}`}>
        {(hasContainer || showTitle) && (
            <div className="lbaic-message-body">
                <div className="lbaic-message-body-in">
                    <div className="lbaic-message-container">
                        <div className="lbaic-message-container-in">
                            {showTitle &&
                                <div className='lbaic-message-title'>
                                    <div className='lbaic-message-title-icon'>
                                        <svg xmlns='http://www.w3.org/2000/svg' fill='none'>
                                            <use href={`#lbaic-chatbot-avatar-${icon}`}/>
                                        </svg>
                                    </div>
                                    <span className='lbaic-message-title-in'>{title}</span>
                                </div>}
                            <div className='lbaic-message'>
                                {children}
                            </div>
                        </div>
                    </div>
                    {(hasContainer && hasActions) && (
                        <div className='lbaic-message-actions'>
                            {agentName && (
                                <div className='lbaic-message-actions-in'>
                                    <span className='lbaic-message-agent-name'>{agentName}</span>
                                </div>
                            )}
                            {time?.length > 0 && (
                                <div className='lbaic-message-actions-in'>
                                    <RealTimeRelativeTime
                                        dateString={time}
                                        className='lbaic-message-time'
                                        tooltipProps={{
                                            arrowPosition: role === 'user' ? 'right' : 'left'
                                        }}
                                    />
                                </div>
                            )}
                            {actions?.length > 0 &&
                                actions.map((action, index) =>
                                    <Action
                                        key={index}
                                        action={action}
                                        tooltipArrowPosition={!time && index === 0 ? 'left' : 'center'}
                                    />
                                )
                            }
                        </div>
                    )}
                </div>
            </div>
        )}
        {errors?.length > 0 &&
            errors.map((error, index) => {
                const args = error.callback?.args?.length > 0 ? error.callback.args : [];
                return (
                    <div key={index} className='lbaic-message-error'>
                        <p className='lbaic-message-error-in' dangerouslySetInnerHTML={{__html: error.message}}/>
                        <ButtonRounded
                            className='lbaic-message-error-action'
                            icon='chat-resend'
                            onClick={() => errorCallback(...args)}
                        />
                    </div>
                );
            })}
    </div>
});

export default Message;