import {useRef, useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import ButtonMinimal from "../../../button/minimal";
import useClickOutside from "../../../../../hooks/use-click-outside";

export default function ChatMenu({uuid, editChat, deleteChat, loading}) {
    const [opened, setOpened] = useState(false);
    const menuRef = useRef(null);

    useClickOutside([menuRef], () => setOpened(false));

    const renameChat = (e) => {
        e.stopPropagation();
        editChat(uuid);
        setOpened(false);
    }

    const handleDeleteChat = (e) => {
        e.stopPropagation();
        deleteChat(uuid);
        setOpened(false);
    }

    return <div ref={menuRef} className='lbaic-message-history-menu'>
        <ButtonMinimal classes='lbaic-button-minimal-28' icon='kebab' onClick={(e) => {
            e.stopPropagation();
            setOpened(!opened);
        }}/>
        {opened &&
            <div className='lbaic-message-history-menu-in'>
                <div className='lbaic-message-history-menu-item'>
                    <button className={`lbaic-message-history-menu-item-in${loading ? ' lbaic-button-disabled' : ''}`} onClick={renameChat}>
                        <svg className='lbaic-message-history-menu-item-i' xmlns='http://www.w3.org/2000/svg'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-edit'/>
                        </svg>
                        <span className='lbaic-message-history-menu-item-label'>{__("Rename", 'limb-chatbot')}</span>
                    </button>
                </div>
                <div className='lbaic-message-history-menu-item'>
                    <button className={`lbaic-message-history-menu-item-in delete${loading ? ' lbaic-button-disabled' : ''}`} onClick={handleDeleteChat}>
                        <svg className='lbaic-message-history-menu-item-i' xmlns='http://www.w3.org/2000/svg'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-delete'/>
                        </svg>
                        <span className='lbaic-message-history-menu-item-label'>{__("Delete", 'limb-chatbot')}</span>
                    </button>
                </div>
            </div>}
    </div>
}