import {handleResponse} from "../../helpers/rest";

/**
 * Delete all plugin data
 *
 * @param {string} restUrl REST base url
 * @param {string} restNonce REST nonce
 * @return {Promise<any>}
 */
export const DeletePluginData = (restUrl, restNonce) => {
    return fetch(`${restUrl}plugin/data`, {
        method: 'DELETE',
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce,
        },
    }).then(handleResponse);
};

/**
 * Get plugin migration status
 *
 * @param {string} restUrl REST base url
 * @param {string} restNonce REST nonce
 * @return {Promise<any>}
 */
export const GetMigrationStatus = (restUrl, restNonce) => {
    return fetch(`${restUrl}plugin/migration-status`, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce,
        },
    }).then(handleResponse);
};

/**
 * Run plugin migration
 *
 * @param {string} restUrl REST base url
 * @param {string} restNonce REST nonce
 * @return {Promise<any>}
 */
export const RunMigration = (restUrl, restNonce) => {
    return fetch(`${restUrl}plugin/migrate`, {
        method: 'POST',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-WP-Nonce': restNonce,
        },
    }).then(handleResponse);
};
