import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get model metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {number} id Model ID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetModelMetas = (restUrl, restNonce, id, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}models/${id}/metas${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

/**
 * Update model metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {number} id Model ID
 * @param {object} requestData Model metas data to update
 * @return {Promise<any>}
 * @constructor
 */
export const UpdateModelMetas = (restUrl, restNonce, id, requestData) => {
    return fetch(`${restUrl}models/${id}/metas/batch`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        },
        body: JSON.stringify(requestData)
    }).then(handleResponse);
}