import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get live agents
 *
 * @param {number} configId Config ID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetLiveAgents = (configId, params = {}) => {
    const query = urlSearchParams(params, '&');

    return fetch(`${LimbChatbot.rest.url}live-agents?config_id=${configId}${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}