import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get slack channels
 *
 * @param {number} configId Config ID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetSlackChannels = (configId, params = {}) => {
    const query = urlSearchParams(params, '&');

    return fetch(`${LimbChatbot.rest.url}integrations/slack/channels?config_id=${configId}${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}

/**
 * Get slack agents
 *
 * @param {number} configId Config ID
 * @param {object} params Query params
 * @return {Promise<*>}
 * @constructor
 */
export const GetSlackAgents = (configId, params = {}) => {
    const query = urlSearchParams(params, '&');

    return fetch(`${LimbChatbot.rest.url}integrations/slack/agents?config_id=${configId}${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}

/**
 * Create slack agents
 *
 * @param {number} configId Config ID
 * @param {object} requestData Request data with ids array
 * @return {Promise<*>}
 * @constructor
 */
export const CreateSlackAgents = (configId, requestData) => {
    return fetch(`${LimbChatbot.rest.url}integrations/slack/agents?config_id=${configId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        },
        body: JSON.stringify(requestData)
    }).then(handleResponse);
}

/**
 * Get telegram users (private chats)
 *
 * @param {number} configId Config ID
 * @param {object} params Query params
 * @return {Promise<*>}
 * @constructor
 */
export const GetTelegramUsers = (configId, params = {}) => {
    const query = urlSearchParams(params, '&');

    return fetch(`${LimbChatbot.rest.url}integrations/telegram/users?config_id=${configId}${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}

/**
 * Get telegram agents (for adding to live agents)
 *
 * @param {number} configId Config ID
 * @param {object} params Query params
 * @return {Promise<*>}
 * @constructor
 */
export const GetTelegramAgents = (configId, params = {}) => {
    const query = urlSearchParams(params, '&');

    return fetch(`${LimbChatbot.rest.url}integrations/telegram/agents?config_id=${configId}${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}

/**
 * Create telegram agents
 *
 * @param {number} configId Config ID
 * @param {object} requestData Request data with ids array
 * @return {Promise<*>}
 * @constructor
 */
export const CreateTelegramAgents = (configId, requestData) => {
    return fetch(`${LimbChatbot.rest.url}integrations/telegram/agents?config_id=${configId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        },
        body: JSON.stringify(requestData)
    }).then(handleResponse);
}

/**
 * Refresh telegram users from Telegram API
 *
 * @param {number} configId Config ID
 * @return {Promise<*>}
 * @constructor
 */
export const RefreshTelegramUsers = (configId) => {
    return fetch(`${LimbChatbot.rest.url}integrations/telegram/users?config_id=${configId}&refresh=true`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}

