import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get dataset metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {number} id Dataset ID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetDatasetMetas = (restUrl, restNonce, id, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}datasets/${id}/metas${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

/**
 * Update dataset metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {number} id Dataset ID
 * @param {object} requestData Dataset metas data to update
 * @return {Promise<any>}
 * @constructor
 */
export const UpdateDatasetMetas = (restUrl, restNonce, id, requestData) => {
    return fetch(`${restUrl}datasets/${id}/metas/batch`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        },
        body: JSON.stringify(requestData)
    }).then(handleResponse);
}