import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get chatbot chat
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {string} chatUuid Chat UUID
 * @param {object} params Query params
 * @return {Promise<any>}
 */
export const GetChat = (restUrl, restNonce, chatUuid, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chats/${chatUuid}${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

/**
 * Get chatbot chat
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {object} params Query params
 * @return {Promise<any>}
 */
export const GetChats = (restUrl, restNonce,params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chats${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

/**
 * Delete chatbot chat
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {string} chatUUID Chat UUID
 * @return {Promise<any>}
 */

export const DeleteChat = (restUrl, restNonce, chatUUID) => {
    return fetch(`${restUrl}chats/${chatUUID}` , {
        method: 'DELETE',
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

/**
 * Get Chat messages
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {string} chatUUID Chatbot UUID
 * @param {object} params Query params
 * @return {Promise<any>}
 */

export const GetChatMessages = (restUrl, restNonce, chatUUID, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chats/${chatUUID}/messages${query}` , {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}