import {handleResponse} from "../../helpers/rest";
import {urlSearchParams} from "../../../helpers";

/**
 * Get chatbot users data.
 * API returns {items: Array, total: number, page: number, per_page: number}.
 *
 * @param {object} params Query parameters (page, per_page, search, etc.)
 * @return {Promise<{items: Array, total: number, page: number, per_page: number}>}
 */
export const GetChatbotUsers = (params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${LimbChatbot.rest.url}chatbot-users${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
};
