import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

export const GetChatbotTemplates = (restUrl, restNonce, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chatbot_templates${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

export const GetChatbotTemplate = (restUrl, restNonce, name, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chatbot_templates/${name}${query}`, {
        headers: {
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}