import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get chatbot metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {number} id Chatbot post ID
 * @param {object} params Query params
 * @return {Promise<*>}
 * @constructor
 */
export const GetChatbotMetas = (restUrl, restNonce, id, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chatbots/${id}/metas${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

/**
 * Update chatbot metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {number} id Chatbot post ID
 * @param {object[]} requestData Settings to create/update
 * @param {object} params Query params
 * @return {Promise<any>}
 */
export const UpdateChatbotMetas = (restUrl, restNonce, id, requestData, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chatbots/${id}/metas/batch${query}`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        },
        body: JSON.stringify(requestData)
    }).then(handleResponse);
}