import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get actions
 *
 * @param {string} chatbotUuid Chatbot UUID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetChatbotAnalytics = (chatbotUuid, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${LimbChatbot.rest.url}chatbots/${chatbotUuid}/analytics${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}

/**
 * Get actions
 *
 * @param {string} chatbotUuid Chatbot UUID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetChatbotAnalyticsTypes = (chatbotUuid, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${LimbChatbot.rest.url}chatbots/${chatbotUuid}/analytics/types${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}