import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get chat metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {string} uuid Chat UUID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetChatMetas = (restUrl, restNonce, uuid, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${restUrl}chats/${uuid}/metas${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        }
    }).then(handleResponse);
}

/**
 * Update chat metas
 *
 * @param {string} restUrl Rest url
 * @param {string} restNonce Rest nonce
 * @param {string} uuid Chat UUID
 * @param {object} requestData Chat metas data to update
 * @return {Promise<any>}
 * @constructor
 */
export const UpdateChatMetas = (restUrl, restNonce, uuid, requestData) => {
    return fetch(`${restUrl}chats/${uuid}/metas/batch`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-WP-Nonce': restNonce
        },
        body: JSON.stringify(requestData)
    }).then(handleResponse);
}