import {urlSearchParams} from "../../../helpers";
import {handleResponse} from "../../helpers/rest";

/**
 * Get actions
 *
 * @param {number} actionId Action ID
 * @param {object} params Query params
 * @return {Promise<any>}
 * @constructor
 */
export const GetActionEntries = (actionId, params = {}) => {
    const query = urlSearchParams(params);

    return fetch(`${LimbChatbot.rest.url}actions/${actionId}/submissions${query}`, {
        headers: {
            'Accept': 'application/json',
            'X-WP-Nonce': LimbChatbot.rest.nonce
        }
    }).then(handleResponse);
}