import domReady from '@wordpress/dom-ready';
import {createRoot} from '@wordpress/element';
import Settings from './components/pages/settings';
import SetupGeneralHooks from './helpers/hooks/general';

SetupGeneralHooks();

domReady(() => {
    const container = document.getElementById('lbaic-admin-page-settings');
    if (!container) {
        // No container found to initialize
        return;
    }
    const root = createRoot(container);

    root.render(
        <Settings/>
    );
});