import {__, sprintf} from '@wordpress/i18n';
import {createHooks} from '@wordpress/hooks';
import {getNavLinkToParams} from "./helpers";
import Dashboard from "./components/pages/settings/pages/general/chatbot/dashboard";
import Settings from "./components/pages/settings/pages/general/chatbot/settings";
import Appearance from "./components/pages/settings/pages/general/chatbot/appearance";
import Chats from "./components/pages/settings/pages/general/chatbot/chats";
import Widgets from "./components/pages/settings/pages/general/chatbot/widgets";
import CostsLimits from "./components/pages/settings/pages/general/chatbot/costs-limits";
import LiveAgent from "./components/pages/settings/pages/general/chatbot/live-agent";
import KnowledgeSources from "./components/pages/settings/pages/knowledge/sources";
import KnowledgeAutoSync from "./components/pages/settings/pages/knowledge/auto-sync";
import KnowledgeRecommendations from "./components/pages/settings/pages/knowledge/recommendations";
import KnowledgeActions from "./components/pages/settings/pages/actions/actions";
import KnowledgeSettings from "./components/pages/settings/pages/knowledge/settings";
import Leads from "./components/pages/settings/pages/leads/leads";
import LeadsVisitors from "./components/pages/settings/pages/leads/visitors";
import OpenAiUtilityChatbot from "./components/pages/settings/pages/ai-providers/open-ai/utilities/chatbot";
import GeminiUtilityChatbot from "./components/pages/settings/pages/ai-providers/gemini/utilities/chatbot";
import DeepSeekUtilityChatbot from "./components/pages/settings/pages/ai-providers/deep-seek/utilities/chatbot";
import Badge from "./components/fields/badge";
import ActionsIntegrations from "./components/pages/settings/pages/actions/integrations";
import NotificationsSettings from "./components/pages/settings/pages/notifications/settings";
import NotificationsLogs from "./components/pages/settings/pages/notifications/logs";

if (!LimbChatbot?.Hooks) {
    LimbChatbot.Hooks = createHooks();
}

/**
 * Add Chatbot, Knowledge and Actions in the navigation menu
 */
LimbChatbot.Hooks.addFilter('lbaic.admin.page.settings.navItems', 'lbaic/admin/page/settings/nav-items', (navItems) => {
    navItems.unshift(
        // Chatbot
        {
            icon: <svg className='lbaic-settings-nav-item-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                       viewBox='0 0 24 24'>
                <use href='#lbaic-settings-nav-chatbot' className='lbaic-settings-nav-item-icon default'/>
            </svg>,
            label: __("Chatbot", 'limb-chatbot'),
            subTitle: __("Configure your default chatbot.", 'limb-chatbot'),
            badge: <Badge label={__("Default", 'limb-chatbot')} isSmall/>,
            slug: 'chatbot',
            tabs: LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.navItems.general.chatbot.tabs', [
                {
                    icon:
                        <svg
                            className='lbaic-settings-tab-i'
                            xmlns='http://www.w3.org/2000/svg'
                            fill='none'
                            viewBox='0 0 24 24'
                        >
                            <use href='#lbaic-settings-tab-dashboard' className='lbaic-settings-tab-icon default stroke'/>
                            <use href='#lbaic-settings-tab-dashboard' className='lbaic-settings-tab-icon active stroke'/>
                        </svg>,
                    label: __("Dashboard", 'limb-chatbot'),
                    slug: 'dashboard',
                },
                {
                    icon:
                        <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-tab-ai-settings' className='lbaic-settings-tab-icon default'/>
                            <use href='#lbaic-settings-tab-ai-settings-active' className='lbaic-settings-tab-icon active'/>
                        </svg>,
                    label: __("AI", 'limb-chatbot'),
                    slug: 'ai-settings',
                },
                {
                    icon:
                        <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-tab-appearance' className='lbaic-settings-tab-icon default'/>
                            <use href='#lbaic-settings-tab-appearance-active' className='lbaic-settings-tab-icon active'/>
                        </svg>,
                    label: __("Appearance", 'limb-chatbot'),
                    slug: 'appearance',
                },
                {
                    icon:
                        <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-tab-qas' className='lbaic-settings-tab-icon default'/>
                            <use href='#lbaic-settings-tab-qas' className='lbaic-settings-tab-icon active'/>
                        </svg>,
                    label: __("Chats", 'limb-chatbot'),
                    slug: 'chats',
                },
                {
                    icon:
                        <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-tab-live-agent' className='lbaic-settings-tab-icon default'/>
                            <use href='#lbaic-settings-tab-live-agent' className='lbaic-settings-tab-icon active'/>
                        </svg>,
                    label: __("Live agent", 'limb-chatbot'),
                    slug: 'live-agent',
                },
                {
                    icon:
                        <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-tab-pw' className='lbaic-settings-tab-icon default'/>
                            <use href='#lbaic-settings-tab-pw-active' className='lbaic-settings-tab-icon active'/>
                        </svg>,
                    label: __("Widgets", 'limb-chatbot'),
                    slug: 'widgets',
                },
                {
                    icon:
                        <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-tab-cl' className='lbaic-settings-tab-icon default'/>
                            <use href='#lbaic-settings-tab-cl-active' className='lbaic-settings-tab-icon active'/>
                        </svg>,
                    label: __("Costs & Limits", 'limb-chatbot'),
                    slug: 'costs-limits',
                }
            ]),
        },
        // Knowledge
        {
            label: __("Knowledge", 'limb-chatbot'),
            slug: 'knowledge',
            icon: <svg className='lbaic-settings-nav-item-i lbaic-settings-nav-item-kb-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                       viewBox='0 0 24 24'>
                <use href='#lbaic-settings-advanced'/>
            </svg>,
            tabs: LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.navItems.general.knowledge.tabs', [
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-knowledge-sources' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-knowledge-sources' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Sources", 'limb-chatbot'),
                    subTitle: sprintf(__("Your chatbot learns from the knowledge sources you provide.", "limb-chatbot"), '<br/>') + ' <a href="https://wpaichatbot.com/documentation/teaching-your-chatbot/adding-knowledge-to-your-chatbot/" target="_blank">' + __('Learn more', 'limb-chatbot' ) + '</a>',
                    slug: 'sources',
                },
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-knowledge-recommendations' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-knowledge-recommendations' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Recommendations", 'limb-chatbot'),
                    subTitle: sprintf(__("Learn from CPTs for future recommendations.", 'limb-chatbot'), '<br/>') + ' <a href="https://wpaichatbot.com/documentation/teaching-your-chatbot/recommending-custom-post-types/" target="_blank">' + __('Learn more', 'limb-chatbot' ) + '</a>',
                    slug: 'recommendations',
                },
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill="none"
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-knowledge-auto-sync' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-knowledge-auto-sync' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Auto-sync", 'limb-chatbot'),
                    subTitle: __("Automatically sync your WordPress content to your knowledge.", 'limb-chatbot'),
                    slug: 'auto-sync',
                },
                {
                    icon:
                        <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-tab-knowledge-settings' className='lbaic-settings-tab-icon stroke default'/>
                            <use href='#lbaic-settings-tab-knowledge-settings' className='lbaic-settings-tab-icon stroke active'/>
                        </svg>,
                    label: __("Settings", 'limb-chatbot'),
                    subTitle: __("Configure how your chatbot collects, stores, and retrieves knowledge.", 'limb-chatbot') + ' <a href="https://wpaichatbot.com/documentation/teaching-your-chatbot/adding-knowledge-to-your-chatbot/#knowledge-settings" target="_blank">'+ __("Learn more", 'limb-chatbot') +'</a>',
                    slug: 'settings',
                },
            ])
        },
        // Leads
        {
            label: __("Leads", 'limb-chatbot'),
            subTitle: __("Manage all leads captured across all chatbots and actions.", 'limb-chatbot'),
            slug: 'leads',
            icon: (
                <svg className='lbaic-settings-nav-item-i lbaic-settings-nav-item-kb-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-tab-leads'/>
                </svg>
            ),
            tabs: LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.navItems.general.leads.tabs', [
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-dashboard-leads_captured' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-dashboard-leads_captured' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Leads", 'limb-chatbot'),
                    subTitle: __("Manage all leads captured across all chatbots and actions.", 'limb-chatbot'),
                    slug: 'leads',
                },
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-user-2' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-user-2' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Visitors", 'limb-chatbot'),
                    title: __('Visitors', 'limb-chatbot'),
                    subTitle: __("Manage all visitors.", "limb-chatbot"),
                    slug: 'visitors',
                }
            ])
        },
        // Actions
        {
            label: __("Actions", 'limb-chatbot'),
            subTitle: __("Actions let your chatbot DO things beyond answering questions.", 'limb-chatbot') + ' <a href="https://wpaichatbot.com/documentation/what-your-chatbot-can-do/understanding-actions/" target="_blank">'+ __("Learn more", 'limb-chatbot') +'</a>',
            slug: 'actions',
            icon: (
                <svg className='lbaic-settings-nav-item-i lbaic-settings-nav-item-kb-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-menu-actions'/>
                </svg>
            ),
            tabs: LimbChatbot.Hooks.applyFilters('lbaic.admin.page.settings.navItems.general.actions.tabs', [
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-actions' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-actions' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Actions", 'limb-chatbot'),
                    slug: 'actions',
                },
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-integrations' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-integrations' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    title: __("Integrations", 'limb-chatbot'),
                    label: __("Integrations", 'limb-chatbot'),
                    // subTitle: __("", 'limb-chatbot'),
                    slug: 'integrations',
                    disabled: true,
                    badge: <Badge label={__("Soon", 'limb-chatbot')} isSmall/>,
                }
            ])
        },
        // Notifications
        {
            icon: (
                <svg
                    className='lbaic-settings-nav-item-i lbaic-settings-nav-item-kb-i'
                    xmlns='http://www.w3.org/2000/svg'
                    fill='none'
                    viewBox='0 0 24 24'
                >
                    <use href='#lbaic-settings-menu-notifications'/>
                </svg>
            ),
            label: __("Notifications", 'limb-chatbot'),
            subTitle: __("Configure notification preferences.", 'limb-chatbot'),
            slug: 'notifications',
            tabs: [
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                              viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-knowledge-settings' className='lbaic-settings-tab-icon stroke default'/>
                        <use href='#lbaic-settings-tab-knowledge-settings' className='lbaic-settings-tab-icon stroke active'/>
                    </svg>,
                    label: __("Settings", 'limb-chatbot'),
                    slug: 'settings',
                },
                {
                    icon: <svg className='lbaic-settings-tab-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                               viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-tab-logs' className='lbaic-settings-tab-icon default stroke'/>
                        <use href='#lbaic-settings-tab-logs' className='lbaic-settings-tab-icon active stroke'/>
                    </svg>,
                    label: __("Logs", 'limb-chatbot'),
                    slug: 'logs',
                    disabled: true,
                    badge: <Badge label={__("Soon", 'limb-chatbot')} isSmall/>,
                },
            ],
        },
    );

    return navItems;
});

/**
 * Add Chatbot, Knowledge and Actions menu item tab pages
 */
LimbChatbot.Hooks.addFilter('lbaic.admin.page.settings.pages', 'lbaic/admin/page/settings/pages', (pages) => {
    pages = {
        ...pages,
        // Chatbot
        [getNavLinkToParams('chatbot', 'dashboard', true)]: Dashboard,
        [getNavLinkToParams('chatbot', 'ai-settings', true)]: Settings,
        [getNavLinkToParams('chatbot', 'appearance', true)]: Appearance,
        [getNavLinkToParams('chatbot', 'costs-limits', true)]: CostsLimits,
        [getNavLinkToParams('chatbot', 'widgets', true)]: Widgets,
        [getNavLinkToParams('chatbot', 'chats', true)]: Chats,
        [getNavLinkToParams('chatbot', 'live-agent', true)]: LiveAgent,
        // Knowledge
        [getNavLinkToParams('knowledge', 'sources', true)]: KnowledgeSources,
        [getNavLinkToParams('knowledge', 'recommendations', true)]: KnowledgeRecommendations,
        [getNavLinkToParams('knowledge', 'auto-sync', true)]: KnowledgeAutoSync,
        [getNavLinkToParams('knowledge', 'settings', true)]: KnowledgeSettings,
        // Leads
        [getNavLinkToParams('leads', 'leads', true)]: Leads,
        [getNavLinkToParams('leads', 'visitors', true)]: LeadsVisitors,
        // Actions
        [getNavLinkToParams('actions', 'actions', true)]: KnowledgeActions,
        [getNavLinkToParams('actions', 'integrations', true)]: ActionsIntegrations,
        // Notifications
        [getNavLinkToParams('notifications', 'settings', true)]: NotificationsSettings,
        [getNavLinkToParams('notifications', 'logs', true)]: NotificationsLogs,
    };

    return pages;
});

/**
 * Add Chatbot accordion item in AI model utilities
 */
LimbChatbot.Hooks.addFilter('lbaic.admin.page.settings.ai-provider.utilities', 'lbaic/admin/page/settings/ai-provider/utilities', (utilities, aiProviderId) => {
    let utility = null;
    if (aiProviderId === 'open-ai') {
        utility = OpenAiUtilityChatbot;
    } else if (aiProviderId === 'gemini') {
        utility = GeminiUtilityChatbot;
    } else if (aiProviderId === 'deep-seek') {
        utility = DeepSeekUtilityChatbot;
    }

    if (utility) {
        utilities = {
            chatbot: utility,
            ...utilities,
        };
    }

    return utilities;
});