import {generateUniqueId} from "../../../helpers";

/**
 * Handle success
 *
 * @param {function} addNotification Notifications
 * @param {{title: string, description: string}} info Info about the error
 */
export const handleSuccess = (addNotification, info) => {
    typeof addNotification === 'function' && addNotification((prev) => {
        return [...prev, {
            id: generateUniqueId(),
            type: 'success',
            ...info,
        }]
    });
}

/**
 * Handle error
 *
 * @param {Event|object|false} e Event
 * @param {function} addNotification Notifications
 * @param {{title: string, description: string}} info Info about the error
 */
export const handleWarning = (e, addNotification, info) => {
    if (LimbChatbot.config.debug && e !== false) {
        console.warn(e);
    }
    typeof addNotification === 'function' && addNotification((prev) => [...prev, {
        id: generateUniqueId(),
        type: 'warning',
        ...info,
    }]);
}

/**
 * Handle error
 *
 * @param {Event|object|false} e Event
 * @param {function} addNotification Notifications
 * @param {{title: string, description: string}} info Info about the error
 */
export const handleError = (e, addNotification, info) => {
    if (LimbChatbot.config.debug && e !== false) {
        console.error(e);
    }
    typeof addNotification === 'function' && addNotification((prev) => [...prev, {
        id: generateUniqueId(),
        type: 'error',
        ...info,
    }]);
}