import {createHooks} from '@wordpress/hooks';
import {__, sprintf} from '@wordpress/i18n';
import {required} from '../../../validations';
import Description from "../../components/sections/description";
import Notice from "../../components/sections/notice";

export default function _() {
    if (!LimbChatbot?.Hooks) {
        LimbChatbot.Hooks = createHooks();
    }

    /**
     * Register Slack config fields filter (globalized)
     */
    LimbChatbot.Hooks.addFilter('lbaic.admin.page.settings.config.dataToCreate.fields', 'lbaic/admin/page/settings/config/slack/fields', (fields, aiProviderId) => {
        if (aiProviderId === 'slack') {
            return [
                {
                    label: __("Signing Secret", 'limb-chatbot'),
                    name: 'signing_secret',
                    defaultValue: '',
                    type: 'input',
                    validations: [required],
                    description: (
                        <Description>{__("Get from Basic Information → App Credentials → Signing Secret.", 'limb-chatbot')} <a href="https://wpaichatbot.com/documentation/api-keys-external-services/getting-slack-api-keys/#step-2-collect-signing-secret" target="_blank">{__("Learn more", 'limb-chatbot')}</a></Description>
                    )
                },
                {
                    label: __("App Token", 'limb-chatbot'),
                    name: 'app_token',
                    defaultValue: '',
                    type: 'input',
                    validations: [required],
                    description: (
                        <Description>{__("Get from Basic Information → App-Level Tokens (generate if needed).", 'limb-chatbot')} <a href="https://wpaichatbot.com/documentation/api-keys-external-services/getting-slack-api-keys/#step-6-generate-app-level-token" target="_blank">{__("Learn more", 'limb-chatbot')}</a></Description>
                    )
                },
                {
                    type: 'render_content',
                    content: (
                        <div className='lbaic-settings-column'>
                            <Notice
                                type="warning"
                                desc={(() => {
                                    const scopes = [
                                        'chat:write',
                                        'chat:write.public',
                                        'channels:read',
                                        'channels:history',
                                        'groups:read',
                                        'groups:history',
                                        'im:read',
                                        'im:write',
                                        'mpim:read',
                                        'mpim:write',
                                        'users:read',
                                        'users:read.email',
                                        'app_mentions:read',
                                        'channels:manage',
                                        'groups:write',
                                    ];
                                    const scopesList = scopes.map(scope => `<code>${scope}</code>`).join(', ');
                                    return sprintf(__("Please make sure you've added these scopes %s in the %sOAuth & Permissions → Scopes → Bot Token Scopes%s.%sNote: %sAfter enabling those scopes, please reinstall the app so the new state is up-to-date%s.", 'limb-chatbot'), scopesList, '<strong>', '</strong>', '<br/>', '<strong>', '</strong>');
                                })()}
                                dismissible={false}
                            />
                        </div>
                    ),
                    skipSaving: true
                },
                {
                    label: __("Bot User OAuth Token", 'limb-chatbot'),
                    name: 'bot_token',
                    defaultValue: '',
                    type: 'input',
                    validations: [required],
                    description: (
                        <Description>{__("Get from OAuth & Permissions → OAuth Tokens (after workspace installation).", 'limb-chatbot')} <a href="https://wpaichatbot.com/documentation/api-keys-external-services/getting-slack-api-keys/#step-5-copy-bot-user-oauth-token" target="_blank">{__("Learn more", 'limb-chatbot')}</a></Description>
                    )
                }
            ];
        }
        return fields;
    });

    /**
     * Register Telegram config fields filter (globalized)
     */
    LimbChatbot.Hooks.addFilter('lbaic.admin.page.settings.config.dataToCreate.fields', 'lbaic/admin/page/settings/config/telegram/fields', (fields, aiProviderId) => {
        if (aiProviderId === 'telegram') {
            return [
                {
                    label: __("Bot Token", 'limb-chatbot'),
                    name: 'bot_token',
                    defaultValue: '',
                    type: 'input',
                    validations: [required],
                    description: (
                        <Description>{__("Get from @BotFather after creating your bot.", 'limb-chatbot')} <a href="https://core.telegram.org/bots#botfather" target="_blank">{__("Learn more", 'limb-chatbot')}</a></Description>
                    )
                },
            ];
        }
        return fields;
    });

    /**
     * Register Gemini config fields filter (globalized)
     */
    LimbChatbot.Hooks.addFilter('lbaic.admin.page.settings.config.dataToCreate.fields', 'lbaic/admin/page/settings/config/gemini/fields', (fields, aiProviderId) => {
        if (aiProviderId === 'gemini') {
            fields.push({
                label: __("Paid Tier", 'limb-chatbot'),
                name: 'paid_tier',
                defaultValue: 0,
                type: 'checkbox',
                description: (
                    <Description>{__("Enable if you're using a paid Google Cloud plan", 'limb-chatbot')} <a href="https://wpaichatbot.com/documentation/api-keys-external-services/connecting-google-gemini/#step-2-fill-in-configuration-fields" target="_blank">{__("Learn more", 'limb-chatbot')}</a></Description>
                )
            });
        }
        return fields;
    });
}