import confetti from 'canvas-confetti';

export const launchConfetti = () => {
    const defaults = {
        startVelocity: 18,
        spread: 360,
        ticks: 140,
        gravity: 0.6,
        decay: 0.96,
        zIndex: 0
    };

    const bursts = [
        { x: 0.25, y: 0.25 },
        { x: 0.75, y: 0.25 },
        { x: 0.5, y: 0.5 }
    ];

    const particleCount = 100;
    let index = 0;

    const runBurst = () => {
        if (index >= bursts.length) return;

        const burst = bursts[index];
        index++;

        confetti({
            ...defaults,
            particleCount,
            origin: burst
        });

        setTimeout(runBurst, 1000);
    };

    runBurst();
};
