/**
 * AI provider info
 *
 * @type {{"open-ai": {utilities: string[]}, gemini: {utilities: string[]}, "deep-seek": {utilities: [string]}, claude: {utilities: [string]}}}
 */
const AI_PROVIDERS = {
    'open-ai': {
        utilities: [
            'chatbot',
            'embedding',
            'fine-tuning',
            'copilot'
        ],
    },
    'gemini': {
        utilities: [
            'chatbot',
            'embedding',
            'copilot'
        ],
    },
    'deep-seek': {
        utilities: [
            'chatbot',
            'copilot'
        ],
    },
    'claude': {
        utilities: [
            'chatbot',
            'copilot'
        ],
    },
    'grok': {
        utilities: [
            'chatbot',
            'copilot'
        ],
    },
};

/**
 * Get AI providers available for utility
 *
 * @param {string} utility Utility name
 * @return {string[]}
 */
export const getUtilityAIProviders = (utility) => {
    return Object.keys(AI_PROVIDERS).filter(aiProviderId => AI_PROVIDERS[aiProviderId]?.utilities?.includes(utility));
}

/**
 * Get AI provider available utilities
 *
 * @param {string} aiProviderId AI provider ID
 * @return {string[]}
 */
export const getAIProviderUtilities = (aiProviderId) => {
    try {
        return AI_PROVIDERS[aiProviderId]?.utilities ?? ['chatbot'];
    } catch (e) {
        return [
            'chatbot'
        ];
    }
}