// 10000 - 10099: Validation errors.
// Errors related to invalid inputs, incorrect formats, or missing required values
export const VALIDATION_BAD_BASE64 = 10006;  // Bad base64 format error
export const VALIDATION_UNSUPPORTED_MIME_TYPE = 10007;  // Unsupported mime type error
export const VALIDATION_VALUE_EXISTS = 10008;  // Value already exists error
export const VALIDATION_INVALID_VALUE = 10009; // Invalid value error
export const VALIDATION_REQUIRED = 10010; // Required value missing error
export const VALIDATION_UNSUPPORTED_VALUE = 10011; // Unsupported value
export const VALIDATION_INVALID_OR_MISSING_FILE = 10012; // Unsupported value
export const VALIDATION_UNEXPECTED_CSV_COLUMN = 10013; // Unsupported value
export const VALIDATION_FILE_SIZE_LIMIT = 10014; // File size exceeds the limit


// 10100 - 10199: Chatbot-related errors.
// Errors related to chatbot message handling, processing, and communication with the user
export const CHATBOT_MESSAGE_ALREADY_SENT = 10101;  // Message already sent error
export const CHATBOT_LIMIT_EXCEED = 10102;  // Chatbot limit exceed error
export const CHATBOT_MESSAGE_PREPARATION_FAILED = 10103;  // Message preparation failed error
export const CHATBOT_NO_ACTIVE_USER_MESSAGE = 10104;  // No active user message error
export const CHATBOT_NO_MESSAGES = 10105;  // No messages to process error
export const CHATBOT_PROMPT_MISSING = 10106; // Missing user prompt error
export const CHATBOT_REQUEST_IN_PROGRESS = 10107; // Request in progress error
export const CHATBOT_FAILED_REPLY = 10108; // Failed to generate a reply error
export const CHATBOT_SYSTEM_MESSAGE_IS_MISSING = 10109; // Failed to generate a reply error


// 10200 - 10299: Authentication/Configuration errors.
// Errors related to API key, user authentication, and system configuration issues
export const AUTHENTICATION_API_KEY_MISSING = 10200;  // Missing API key error
export const AUTHENTICATION_UNAUTHORIZED = 10201; // Unauthorized access error
export const QUOTA_EXCEED = 10202;


// 10300 - 10399: Data handling and argument validation errors.
// Errors related to invalid data or incorrect arguments passed to functions
export const DATA_INVALID_VECTOR_ARGUMENT = 10301;  // Invalid vector argument error
export const DATA_INVALID_AI_MODEL_ARGUMENT = 10302;  // Invalid ai model argument error


// 10700 - 10799: AI Provider general errors.
// Errors related to the AI provider setup or communication issues
export const AI_PROVIDER_NOT_SET = 10700;  // AI provider not set error
export const AI_PROVIDER_MISSING_UTILITY = 10701;  // AI provider utility missing error
export const AI_MODEL_NOT_SET = 10702;  // AI model not set error


// 10600 - 10699: File upload/download errors.
// Errors related to file handling, attachment issues, and upload/download failures
export const FILE_UNABLE_TO_HANDLE_ATTACHMENT = 10604;  // Unable to handle attachment error
export const FILE_UNABLE_TO_CREATE_UPLOAD_DIRECTORY = 10605;
export const FILE_FAILED_TO_MOVE_UPLOADED_FILE = 10606;
export const FILE_FAILED_TO_OPEN = 10607;
export const CSV_FILE_MISSING_OR_INVALID_HEADER = 10608;
export const CSV_FILE_IS_NOT_OPEN = 10609;
export const DATASET_FILE_UPLOAD_MISSING_FILE = 10610;
export const DATASET_FILE_IS_MISSING = 10611;
export const DATASET_FILE_IS_EMPTY = 10612;
export const FILE_FAILED_TO_CREATE = 10613;

// 10700 - 10799: AI Provider-specific errors.
// Errors from specific AI providers (e.g., Gemini, OpenAI, DeepSeek)
export const GEMINI_ERROR = 10700;  // Gemini AI provider error
export const OPEN_AI_ERROR = 10701; // OpenAI provider error
export const DEEP_SEEK_ERROR = 10702; // DeepSeek AI provider error


// 10800 - 10899: System general errors
// General system errors, unexpected responses, missing values, and unsupported features
export const TECHNICAL_ERROR = 10801;  // General technical error
export const UNEXPECTED_RESPONSE_FORMAT = 10802;  // Unexpected response format error
export const NOT_SUPPORTED = 10803;  // Feature not supported error
export const MISSING_VALUE = 10804;  // Missing value error
export const EMPTY_VALUE = 10805;  // Empty value error
export const NOT_FOUND = 10807;  // Not found error

// 10900 - 10999: Vector DB specific errors
export const PINECONE_ERROR = 10901;