// BACKGROUND PROCESS
export const BG_PROCESS_KEY_PREFIX = 'lbaic.bg_processes.';

// STATUS
export const BG_PROCESS_STATUS_START = 'start';
export const BG_PROCESS_STATUS_COMPLETE = 'complete';
export const BG_PROCESS_STATUS_PAUSE = 'pause';
export const BG_PROCESS_STATUS_CANCEL = 'cancel';

// DATASET
export const DIM_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}dataset_import.`;
export const DGEN_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}dataset_generating.`;
export const DIN_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}dataset_indexing.`;
export const DSY_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}dataset_sync.`;
export const DDE_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}dataset_delete.`;
export const DREC_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}dataset_recovery.`;

// FINE-TUNING
export const FTFF_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}fine_tuning_file_formatting.`;

// DATASET PROCESS CONFIGURATION
export const DATASET_PROCESS_CONFIG = {
    dataset_generating: {
        settingsKeyPrefix: DGEN_PROCESS_KEY_PREFIX,
        requiresDatasetIds: false
    },
    dataset_indexing: {
        settingsKeyPrefix: DIN_PROCESS_KEY_PREFIX,
        requiresDatasetIds: false
    },
    dataset_sync: {
        settingsKeyPrefix: DSY_PROCESS_KEY_PREFIX,
        requiresDatasetIds: true
    },
    dataset_delete: {
        settingsKeyPrefix: DDE_PROCESS_KEY_PREFIX,
        requiresDatasetIds: true
    },
    dataset_recovery: {
        settingsKeyPrefix: DREC_PROCESS_KEY_PREFIX,
        requiresDatasetIds: true
    }
};

// File upload
export const FILE_UPLOAD_PROCESS_KEY_PREFIX = `${BG_PROCESS_KEY_PREFIX}file_upload.`;