import Row from "./components/row";
import RowMobile from "./components/row-mobile";
import Pagination from "../pagination";

export default function Table({className, structure, data, loading, pagination, order, _callback, children}) {
    /**
     * Order by
     *
     * @param {string} by Order by
     */
    const orderBy = (by) => {
        if (by === order?.get.orderBy) {
            order.set(prevState => ({
                ...prevState,
                order: prevState.order === 'asc' ? 'desc' : 'asc',
            }));
        } else {
            order?.set(prevState => ({
                ...prevState,
                orderBy: by,
                order: 'asc'
            }));
        }
    }

    /**
     * Render header
     *
     * @param {object} header Header
     * @return {JSX.Element}
     */
    const renderHeader = (header) => {
        return <div key={header.id}
                    className={`lbaic-settings-table-card-header-item${header.className ? ' ' + header.className : ''}${header.sortable ? ' sortable' : ''}${order?.get.orderBy === header.id ? ' ' + order?.get.order : ''}`}
                    onClick={() => header.sortable && orderBy(header.id)}>
            {header.render ?
                header.render()
                : <div className="lbaic-settings-table-card-header-item-in">
                    <span className='lbaic-settings-table-card-header-label'>{header.label}</span>
                    {header.sortable &&
                        <svg className="lbaic-settings-table-card-header-item-arrow"
                             xmlns="http://www.w3.org/2000/svg"
                             fill="none" viewBox="0 0 24 24">
                            <use href="#lbaic-settings-arrow"></use>
                        </svg>}
                </div>}
        </div>
    }

    const mobileHeaders = structure.columns.filter(column => column?.id === 'check');

    return <>
        {/*Desktop*/}
        <div className={`lbaic-settings-table-card-wrapper${className ? ' ' + className : ''}`}>
            <div className='lbaic-settings-table-card'>
                <div className='lbaic-settings-table-card-header'>
                    <div className='lbaic-settings-table-card-header-in'>
                        {structure.columns.map(renderHeader)}
                    </div>
                </div>
                <div className='lbaic-settings-table-card-body'>
                    {children}
                    {data.map((row, rowIndex) => (
                        <Row
                            key={row.id + '-' + rowIndex}
                            structure={structure}
                            row={row}
                            rowIndex={rowIndex}/>
                    ))}
                </div>
            </div>
        </div>
        {/*Mobile*/}
        <div className={`lbaic-settings-table-card-wrapper-mobile${className ? ' ' + className : ''}`}>
            <div className='lbaic-settings-table-card'>
                {mobileHeaders.length > 0 && (
                    <div className='lbaic-settings-table-card-header'>
                        <div className='lbaic-settings-table-card-header-in lbaic-settings-table-card-mobile-header-in'>
                            {mobileHeaders.map(renderHeader)}
                        </div>
                    </div>
                )}
                <div className='lbaic-settings-table-card-body'>
                    {children}
                    {data.map((row, rowIndex) => (
                        <RowMobile
                            key={row.id + '-' + rowIndex}
                            structure={structure}
                            row={row}
                            rowIndex={rowIndex}
                            renderHeader={renderHeader}/>
                    ))}
                </div>
            </div>
        </div>
        {/*Pagination*/}
        {Boolean(pagination) &&
            <Pagination page={pagination.page} perPage={pagination.perPage}
                        total={pagination.total}
                        goTo={(page) => _callback(page, pagination.perPage, order?.get)}
                        loading={loading}/>}
    </>
}