import {useState} from "@wordpress/element";
import RowDetails from "../row-details";

export default function RowMobile({structure, row, rowIndex, renderHeader})  {
    // State for mobile details expansion
    const [expand, setExpand] = useState(false);

    let className = typeof structure.row?.className === 'function' ? structure.row.className(row, rowIndex) : '';
    const hasDetailsToggler = structure.columns.some(column => column.detailsToggler);
    const disabled = typeof structure.row?.disabled === 'function' ? structure.row.disabled(row, rowIndex) : Boolean(structure.row?.disabled);

    const actionColumn = structure.columns.find(column => column?.id === 'actions');
    const checkColumn = structure.columns.find(column => column?.id === 'check');

    // Render detail
    let renderDetails = false;
    if (typeof structure.row?.details?.render === 'function') {
        if (typeof structure.row.details.show === 'function') {
            renderDetails = Boolean(structure.row.details.show(row, rowIndex));
        } else {
            renderDetails = Boolean(structure.row.details.show);
        }
    }

    /**
     * Handle mobile details toggle
     *
     * @param {Event} e Event
     */
    const handleTogglerClick = (e) => {
        // Skip if clicked on kebab menu toggle button or on the checkbox
        if (e.target.closest('.lbaic-settings-kebab-menu-toggle') || e.target.closest('.lbaic-settings-checkbox')) {
            return;
        }
        if (disabled || !hasDetailsToggler) {
            return;
        }
        if (renderDetails) {
            setExpand(!expand);
        } else {
            if (typeof structure.row?.togglerCallback === 'function') {
                structure.row.togglerCallback(row, rowIndex);
            }
        }
    };

    // Had details toggler
    if (hasDetailsToggler) {
        // lbaic-settings-table-card-mobile-clickable
    }

    return (
        <div className='lbaic-settings-table-card-mobile-body'>
            <div
                className={`lbaic-settings-table-card-mobile-body-in lbaic-settings-cursor-pointer${className ? ' ' + className : ''}`}
                onClick={handleTogglerClick}
            >
                <div className='lbaic-settings-table-card-mobile-body-item'>
                    {checkColumn
                        ? (
                            checkColumn.value.render
                                ? checkColumn.value.render(row, rowIndex)
                                : (
                                    <span
                                        className={`lbaic-settings-table-card-mobile-body-label${isNullable ? ' lbaic-settings-table-card-mobile-body-label-null' : ''}`}
                                        dangerouslySetInnerHTML={{__html: checkColumn.value.value(row, rowIndex)}}
                                    />
                                )
                        )
                        : <div className='lbaic-settings-table-card-header-item'></div>
                    }

                    {actionColumn ? (
                        <div
                            className={`lbaic-settings-table-card-body-item${
                                actionColumn.value.className ? ' ' + actionColumn.value.className : ''
                            }`}
                        >
                            {actionColumn.value.render
                                ? actionColumn.value.render(row, rowIndex)
                                : (
                                    <span
                                        className={`lbaic-settings-table-card-mobile-body-label${
                                            typeof actionColumn.value.nullable === 'function' &&
                                            actionColumn.value.nullable(row, rowIndex)
                                                ? ' lbaic-settings-table-card-mobile-body-label-null'
                                                : ''
                                        }`}
                                        dangerouslySetInnerHTML={{
                                            __html: actionColumn.value.value(row, rowIndex),
                                        }}
                                    />
                                )
                            }
                        </div>
                    ) : (
                        <div className="lbaic-settings-table-card-header-item"/>
                    )}
                </div>

                {structure.columns
                    .filter(header => header?.id !== 'actions' && header?.id !== 'check')
                    .map((header) => {
                        const isNullable = typeof header?.value?.nullable === 'function'
                            ? header.value.nullable(row, rowIndex)
                            : false;

                        return (
                            <div
                                key={header.id}
                                className={`lbaic-settings-table-card-mobile-body-item${disabled ? ' lbaic-settings-disabled' : ''}`}
                            >
                                {renderHeader(header)}

                                <div
                                    className={`lbaic-settings-table-card-body-item${header.value.className ? ' ' + header.value.className : ''}`}>
                                    {header.value.render
                                        ? header.value.render(row, rowIndex)
                                        : (
                                            <span
                                                className={`lbaic-settings-table-card-mobile-body-label${isNullable ? ' lbaic-settings-table-card-mobile-body-label-null' : ''}`}
                                                dangerouslySetInnerHTML={{__html: header.value.value(row, rowIndex)}}
                                            />
                                        )
                                    }
                                </div>
                            </div>
                        );
                    })}
            </div>
            {/* Details section */}
            {renderDetails && (
                <RowDetails
                    key={`${row.id}-details`}
                    show={expand}
                    className="lbaic-settings-table-card-mobile-details"
                >
                    {structure.row.details.render(row, rowIndex, expand)}
                </RowDetails>
            )}
        </div>
    );
}