import Badge from "../../fields/badge";

/**
 * Section Header Component
 *
 * @param {Object} props
 * @param {string} props.title - Section title
 * @param {string} props.description - Section description
 * @param {Function} props.onButtonClick - Button click handler
 * @param {string} props.buttonLabel - Button label text
 * @param {string|number} props.badgeLabel - Badge label (count or text)
 */
export default function SectionHeader({title, description, onButtonClick, buttonLabel, badgeLabel}) {
    return (
        <div className='lbaic-settings-section-header'>
            <div className='lbaic-settings-section-header-content'>
                <div className='lbaic-settings-section-header-title-wrapper'>
                    {Boolean(title) && (
                        <h3 className='lbaic-settings-section-header-title'>
                            {title}
                        </h3>
                    )}
                    {badgeLabel !== undefined && (
                        <Badge
                            label={badgeLabel}
                            isSmall
                            custom
                            className='lbaic-settings-section-header-badge'
                        />
                    )}
                </div>
                {Boolean(description) && (
                    <p className='lbaic-settings-section-header-desc'>
                        {description}
                    </p>
                )}
            </div>
            {onButtonClick && buttonLabel && (
                <button
                    className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-32 lbaic-settings-button-secondary'
                    onClick={onButtonClick}>
                    <span className='lbaic-settings-button-label'>{buttonLabel}</span>
                </button>
            )}
        </div>
    );
}