import {useEffect, useState} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import {handleError} from "../../../helpers/notifications";

export default function Pagination({page, perPage, total, goTo, totalItemsLabel, loading}) {
    const [lastPage, setLastPage] = useState(0);

    useEffect(() => {
        updatePages();
    }, [perPage, total]);

    /**
     * Update pages count state
     */
    const updatePages = () => {
        try {
            setLastPage(Math.ceil(total / perPage));
        } catch (e) {
            handleError(e);
        }
    }

    return (lastPage > 1 &&
        <div className='lbaic-settings-pagination'>
            <button
                className={`lbaic-settings-button-reset lbaic-settings-pagination-button${loading || page === 1 ? ' lbaic-settings-pagination-button-disabled' : ''}`}
                onClick={() => !loading && page !== 1 && goTo(1)}>
                <svg className='lbaic-settings-pagination-button-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-fast-prev'/>
                </svg>
            </button>
            <button
                className={`lbaic-settings-button-reset lbaic-settings-pagination-button${loading || page === 1 ? ' lbaic-settings-pagination-button-disabled' : ''}`}
                onClick={() => !loading && page !== 1 && goTo(page - 1)}>
                <svg className='lbaic-settings-pagination-button-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-prev'/>
                </svg>
            </button>
            <span className='lbaic-settings-pagination-label'>{page} {__("of", 'limb-chatbot')} {lastPage}</span>
            <button
                className={`lbaic-settings-button-reset lbaic-settings-pagination-button${loading || page === lastPage ? ' lbaic-settings-pagination-button-disabled' : ''}`}
                onClick={() => !loading && page !== lastPage && goTo(page + 1)}>
                <svg className='lbaic-settings-pagination-button-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-next'/>
                </svg>
            </button>
            <button
                className={`lbaic-settings-button-reset lbaic-settings-pagination-button${loading || page === lastPage ? ' lbaic-settings-pagination-button-disabled' : ''}`}
                onClick={() => !loading && page !== lastPage && goTo(lastPage)}>
                <svg className='lbaic-settings-pagination-button-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-fast-next'/>
                </svg>
            </button>
            <span className='lbaic-settings-pagination-label'>{total} {totalItemsLabel || __("items", 'limb-chatbot')}</span>
        </div>)
}