export default function Divider({label, icon}) {
    return (
        <div className='lbaic-settings-divider-label-container'>
            <div className='lbaic-settings-divider-label-header'>
                {label && (
                    <div className='lbaic-settings-divider-label-header-in'>
                        <div className='lbaic-settings-divider-label-header-info'>
                            <span className='lbaic-settings-divider-label-header-label'>{label}</span>
                            {icon && (
                                <svg className='lbaic-settings-divider-label-header-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                                     viewBox='0 0 24 24'>
                                    <use href={`#lbaic-settings-${icon}`}/>
                                </svg>
                            )}
                        </div>
                    </div>
                )}
            </div>
        </div>
    )
}