import {useState} from '@wordpress/element';
import {__} from '@wordpress/i18n';
import PopupContainer from "../container";
import Input from "../../fields/input";

export default function InsertLink({linkUrl, inserted, close}) {
    const [url, setUrl] = useState(linkUrl || '');

    const handleInsert = () => {
        if (url.trim()) {
            inserted(url.trim());
        }
    };

    const handleKeyDown = (e) => {
        if (e.key === 'Enter') {
            e.preventDefault();
            handleInsert();
        }
    };

    return (
        <PopupContainer
            title={__("Insert Link", 'limb-chatbot')}
            description={__("Enter the URL for the link", 'limb-chatbot')}
            close={close}
            footer={
                <>
                    <button
                        className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-primary'
                        onClick={handleInsert}
                    >
                        <span className='lbaic-settings-button-label'>{__("Insert", 'limb-chatbot')}</span>
                    </button>
                    <button
                        className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-secondary'
                        onClick={close}
                    >
                        <span className='lbaic-settings-button-label'>{__("Cancel", 'limb-chatbot')}</span>
                    </button>
                </>
            }
        >
            <div className='lbaic-settings-column'>
                <div className='lbaic-settings-column-in'>
                    <Input
                        value={url}
                        setValue={setUrl}
                        placeholder={__("https://example.com", 'limb-chatbot')}
                        autofocus
                        onKeyDown={handleKeyDown}
                    />
                </div>
            </div>
        </PopupContainer>
    );
}

