import {__} from "@wordpress/i18n";
import PopupContainer from "../../container";
import Button from "../../../button/_";
import Description from "../../../sections/description";

export default function Migration({onClose, onMigrate, migrating, migrationStatus}) {
    return (
        <PopupContainer
            title={__("Database migration required", 'limb-chatbot')}
            close={migrating ? null : onClose}
            footer={(
                <Button
                    type="primary"
                    label={__("Migrate", 'limb-chatbot')}
                    loading={migrating}
                    onClick={onMigrate}
                    disabled={migrating}
                />
            )}
            style={{
                '--lbaic-settings-desc-in-fs': '14px',
                '--lbaic-settings-desc-in-lh': '18px',
                '--lbaic-settings-desc-in-mbs': 'none',
            }}
        >
            {migrationStatus && (
                <Description>
                    {__("Your database needs to be migrated to continue. This process will update your database structure to match the current plugin version.", 'limb-chatbot')}
                </Description>
            )}
        </PopupContainer>
    );
}