import {useEffect} from "@wordpress/element";
import {__} from "@wordpress/i18n";
import PopupContainer from "../../container";

export default function Confirm({title, description, onCancel, onConfirm, cancelLabel, confirmLabel, style}) {
    useEffect(() => {
        const handleKey = (e) => {
            if (e.key === 'Escape') {
                onCancel();
            }
        }

        window.addEventListener('keydown', handleKey);
        return () => window.removeEventListener('keydown', handleKey);
    }, [onCancel]);

    return <PopupContainer
        close={onCancel}
        title={title}
        description={description}
        layoutStyle={{
            '--lbaic-settings-popup-z-index': '500',
        }}
        style={{
            '--lbaic-settings-popup-max-width': '300px',
            '--lbaic-settings-popup-header-fs': 'var(--lbaic-settings-fs-16)',
            ...style,
        }}
        footer={<>
            <button
                className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-secondary'
                onClick={onCancel}>
                <span className='lbaic-settings-button-label'>{cancelLabel || __("Cancel", 'limb-chatbot')}</span>
            </button>
            <button
                className='lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-primary'
                onClick={onConfirm}>
                <span className='lbaic-settings-button-label'>{confirmLabel || __("Confirm", 'limb-chatbot')}</span>
            </button>
        </>}
    />
}